Ext.data.JsonP.sol_common_ix_services_SordDataCollector({"tagname":"class","name":"sol.common.ix.services.SordDataCollector","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.services.SordDataCollector.js","href":"sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector"}],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.ServiceBase","mixins":[],"requires":[],"uses":[],"members":[{"name":"endLevel","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-endLevel","meta":{}},{"name":"filter","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-filter","meta":{}},{"name":"formatter","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-formatter","meta":{"required":true}},{"name":"maskName","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-maskName","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.ServiceBase","id":"cfg-objId","meta":{}},{"name":"objKeys","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-objKeys","meta":{}},{"name":"pageOfObjId","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-pageOfObjId","meta":{}},{"name":"parentId","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-parentId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"returnDataDefinition","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-returnDataDefinition","meta":{}},{"name":"searchMode","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-searchMode","meta":{}},{"name":"sordKeys","tagname":"cfg","owner":"sol.common.ix.services.SordDataCollector","id":"cfg-sordKeys","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"collectorVersion","tagname":"property","owner":"sol.common.ix.services.SordDataCollector","id":"property-collectorVersion","meta":{"private":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"dataDefinition","tagname":"property","owner":"sol.common.ix.services.SordDataCollector","id":"property-dataDefinition","meta":{}},{"name":"logger","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-logger","meta":{"protected":true}},{"name":"maxFind","tagname":"property","owner":"sol.common.ix.services.SordDataCollector","id":"property-maxFind","meta":{}},{"name":"sordKeyMap","tagname":"property","owner":"sol.common.ix.services.SordDataCollector","id":"property-sordKeyMap","meta":{"protected":true}},{"name":"totalCount","tagname":"property","owner":"sol.common.ix.services.SordDataCollector","id":"property-totalCount","meta":{}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addDocMaskData","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-addDocMaskData","meta":{"private":true}},{"name":"addLocale","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-addLocale","meta":{"private":true}},{"name":"buildDocMaskData","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-buildDocMaskData","meta":{"private":true}},{"name":"buildFindByIndex","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-buildFindByIndex","meta":{"private":true}},{"name":"buildFindDirect","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-buildFindDirect","meta":{"private":true}},{"name":"buildFindInfo","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-buildFindInfo","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"collectSords","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-collectSords","meta":{"private":true}},{"name":"computeSordElementSelector","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-computeSordElementSelector","meta":{"private":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"determinatePageStartIdxByObjId","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-determinatePageStartIdxByObjId","meta":{"private":true}},{"name":"execute","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-execute","meta":{}},{"name":"findGuids","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-findGuids","meta":{"private":true}},{"name":"getSordFormatter","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-getSordFormatter","meta":{"private":true}},{"name":"getTypeConstants","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-getTypeConstants","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"method-initialize","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-process","meta":{"abstract":true}},{"name":"RF_sol_common_services_SordDataCollector_FindClose","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"static-method-RF_sol_common_services_SordDataCollector_FindClose","meta":{"static":true}},{"name":"RF_sol_common_services_SordDataCollector_FindFirst","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"static-method-RF_sol_common_services_SordDataCollector_FindFirst","meta":{"static":true}},{"name":"RF_sol_common_services_SordDataCollector_FindNext","tagname":"method","owner":"sol.common.ix.services.SordDataCollector","id":"static-method-RF_sol_common_services_SordDataCollector_FindNext","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.services.SordDataCollector","short_doc":"Collects all child sords for a given parent in an optimized way. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><strong>sol.common.ix.services.SordDataCollector</strong></div></div></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector' target='_blank'>sol.common.ix.services.SordDataCollector.js</a></div></pre><div class='doc-contents'><p>Collects all child sords for a given parent in an optimized way.</p>\n\n<p>This should be used by dashboards if a larger amount of Sords should be retrieved. In addition information of\nrequired keyword forms and the user locale is returned.</p>\n\n<p>Please gather information carefully. Only the required objKeys and sordKeys should be collected by this service due\nto performance improvements. e.g.</p>\n\n<p>Collecting 10,000 invoices for the invoice dashboard takes ~15s and creates ~80MB of traffic using the IX JS-API since\ndeserializing objects might be expensive. Since only a view information is required this service brings down\nthe execution time to ~5-6s and reduces data traffic to ~6MB. This is done by creating a minimized json-data structure\nwith the help of a string builder.</p>\n\n<h1>Example</h1>\n\n<p>By default StatisticSord formatter is used for generating objects that are optimized for statistical\noperations. Refer to <a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a> for more information.</p>\n\n<pre><code>var result = <a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_common_services_SordDataCollector_FindFirst\", {\n  parentId: '1213',\n  objKeys: [\"INVOICE_DATE\", \"INVOICE_AMOUNT\"]\n});\n</code></pre>\n\n<h1>Result</h1>\n\n<pre><code>{\n  version: '1',\n  formatter: '<a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a>',\n  locale: {\n    language: 'de',\n    dateFormat: 'dd.MM.yyyy',\n    decimalSeperator: ',',\n    groupingSeperator: '.'\n  },\n  sords: [{\n   id: '5669',\n   name: 'Invoice 123',\n   O_INVOICE_DATE: '20151202'\n  }, {\n    // more sords ...\n  }],\n  docMasks: {\n    'Incoming Invoice': {\n      fields: {\n        INVOICE_DATE: { name: 'Invoice Date', type: 'text' }\n      }\n    }\n  },\n  moreResults: true,\n  searchId: \"(0E9AC245-EB29-AB61-5F81-1D744E00EDB8)\"\n}\n</code></pre>\n\n<p> # Handling paging in search results</p>\n\n<p> The current search might contain more results that are not returned. The amount of items returned by one search request can be defined by <code>maxFind</code>.\n A search is automatically closed if all items are returned. If paging is required <code>moreResults=true</code> is returned including a <code>searchId</code> for upcoming requests.</p>\n\n<pre><code> moreResults: true,\n searchId: \"(0E9AC245-EB29-AB61-5F81-1D744E00EDB8)\"\n</code></pre>\n\n<p> Additional results can be retrieved using a search id and the index. If <code>idx=50</code> is passed the search will return the items 50-100 items (as defined by maxFind=50).</p>\n\n<pre><code> var result = <a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_common_services_SordDataCollector_FindNext\", {\n   searchId: \"(0E9AC245-EB29-AB61-5F81-1D744E00EDB8)\",\n   idx: 50\n });\n</code></pre>\n\n<p>Please note that search requests must be closed if a search id was returned.</p>\n\n<pre><code> var result = <a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_common_services_SordDataCollector_FindClose\", {\n   searchId: \"(0E9AC245-EB29-AB61-5F81-1D744E00EDB8)\"\n });\n</code></pre>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-formatter' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-formatter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-formatter' class='name expandable'>formatter</a> : Class<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>Sord object formatter implementation. ...</div><div class='long'><p>Sord object formatter implementation.</p>\n\n<p>e.g. <code><a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a></code> or <code><a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">sol.common.ObjectFormatter.TemplateSord</a></code></p>\n<p>Defaults to: <code>&quot;sol.common.ObjectFormatter.TemplateSord&quot;</code></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-endLevel' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-endLevel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-endLevel' class='name expandable'>endLevel</a> : int<span class=\"signature\"></span></div><div class='description'><div class='short'>Search child objects up to this level below parentId. ...</div><div class='long'><p>Search child objects up to this level below parentId.</p>\n\n<p>Please note that recursively collecting child nodes is expensive and should be handled with care.</p>\n\n<p>A value of 0 or 1 means, that only the sub entries directly under the parent are included.\nSet this value to -1, to search over all levels.\nIn this case the level is internally constrained to 32 to avoid an endless loop,\nif the tree under the parent contains recursive references.</p>\n<p>Defaults to: <code>1</code></p></div></div></div><div id='cfg-filter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-filter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-filter' class='name expandable'>filter</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>List of metadata that limit search results. ...</div><div class='long'><p>List of metadata that limit search results.</p>\n\n<p>This limits search results to a given list of metadata. This list is passed as an FindByIndex ObjKey-Array while\ncollecting search results.</p>\n\n<pre><code>filter: [{ key: 'INVOICE_DATE', val: 'x*' }],\n</code></pre>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='cfg-maskName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-maskName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-maskName' class='name expandable'>maskName</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Restricts search results to a given keywording mask</p>\n</div><div class='long'><p>Restricts search results to a given keywording mask</p>\n</div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-objKeys' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-objKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-objKeys' class='name expandable'>objKeys</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>List of required objKeys. ...</div><div class='long'><p>List of required objKeys.</p>\n\n<p>This only returns the given objKeys. This is required in order to limit traffic for not required keys.</p>\n\n<pre><code>objKeys: [\"INVOICE_DATE\", \"INVOICE_AMOUNT\"],\n</code></pre>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='cfg-pageOfObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-pageOfObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-pageOfObjId' class='name expandable'>pageOfObjId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Page-of GUID\nThe returned page will be determinated by the specified object ID</p>\n</div><div class='long'><p>Page-of GUID\nThe returned page will be determinated by the specified object ID</p>\n</div></div></div><div id='cfg-parentId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-parentId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-parentId' class='name expandable'>parentId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>id of the parent element (guid, objId or archivepath)</p>\n</div><div class='long'><p>id of the parent element (guid, objId or archivepath)</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-returnDataDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-returnDataDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-returnDataDefinition' class='name expandable'>returnDataDefinition</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>If true, the service returns the data definition for the object, which is necessary for the conversion to XML. ...</div><div class='long'><p>If <code>true</code>, the service returns the data definition for the object, which is necessary for the conversion to XML.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-searchMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-searchMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-searchMode' class='name expandable'>searchMode</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(INDEX or DIRECT)\nDefines the search mode. ...</div><div class='long'><p>(INDEX or DIRECT)\nDefines the search mode. Available modes are FindByIndex (Mode <code>INDEX</code>) or Direct-Search (Mode <code>Direct</code>).</p>\n<p>Defaults to: <code>&quot;INDEX&quot;</code></p></div></div></div><div id='cfg-sordKeys' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-cfg-sordKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-cfg-sordKeys' class='name expandable'>sordKeys</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>List of required sord keys. ...</div><div class='long'><p>List of required sord keys.</p>\n\n<p>This only returns the given sord keys. This is required in order to limit traffic for not required keys.</p>\n\n<pre><code>sordKeys: [\"id\", \"guid\", \"name\", \"desc\"],\n</code></pre>\n<p>Defaults to: <code>[&quot;id&quot;, &quot;guid&quot;, &quot;name&quot;]</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-collectorVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-property-collectorVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-property-collectorVersion' class='name expandable'>collectorVersion</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;1.00.000&quot;</code></p></div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-dataDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-property-dataDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-property-dataDefinition' class='name expandable'>dataDefinition</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>for xml transformation\nThis contains the data definition for the result if json objects should be transformed to XML. ...</div><div class='long'><p>for xml transformation\nThis contains the data definition for the result if json objects should be transformed to XML.</p>\n<p>Defaults to: <code>{rootElementName: &quot;data&quot;, dataProperties: [&quot;sord&quot;, &quot;sords&quot;], arrayElementTagNames: {sords: &quot;sord&quot;}}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the service</p>\n</div><div class='long'><p>The logger for the service</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-maxFind' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-property-maxFind' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-property-maxFind' class='name expandable'>maxFind</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Amount of sords that is collected in one step. ...</div><div class='long'><p>Amount of sords that is collected in one step.\nThis is used by the FindFirstSords, FindNextSords function calls.</p>\n<p>Defaults to: <code>50</code></p></div></div></div><div id='property-sordKeyMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-property-sordKeyMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-property-sordKeyMap' class='name expandable'>sordKeyMap</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-totalCount' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-property-totalCount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-property-totalCount' class='name expandable'>totalCount</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>The search is terminated if this number of objects is found. ...</div><div class='long'><p>The search is terminated if this number of objects is found. If the number of results should not be constrained,\nset this value to 232-1 = 2147483647 (maximum value of a positive 32bit integer minus 1).</p>\n\n<p>Please note that collecting huge amounts of data might lead to performance issues.</p>\n<p>Defaults to: <code>10000</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addDocMaskData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-addDocMaskData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-addDocMaskData' class='name expandable'>addDocMaskData</a>( <span class='pre'>maskName</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Adds document mask data ...</div><div class='long'><p>Adds document mask data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addLocale' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-addLocale' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-addLocale' class='name expandable'>addLocale</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-buildDocMaskData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-buildDocMaskData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-buildDocMaskData' class='name expandable'>buildDocMaskData</a>( <span class='pre'>docMaskName</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Builds the document mask data ...</div><div class='long'><p>Builds the document mask data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>docMaskName</span> : String<div class='sub-desc'><p>Document mask name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-buildFindByIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-buildFindByIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-buildFindByIndex' class='name expandable'>buildFindByIndex</a>( <span class='pre'>findInfo</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findInfo</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildFindDirect' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-buildFindDirect' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-buildFindDirect' class='name expandable'>buildFindDirect</a>( <span class='pre'>findInfo</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findInfo</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-buildFindInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-buildFindInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-buildFindInfo' class='name expandable'>buildFindInfo</a>( <span class='pre'>findInfo</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findInfo</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-collectSords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-collectSords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-collectSords' class='name expandable'>collectSords</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-computeSordElementSelector' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-computeSordElementSelector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-computeSordElementSelector' class='name expandable'>computeSordElementSelector</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Computes a SordZ selector for information that is required. ...</div><div class='long'><p>Computes a SordZ selector for information that is required.</p>\n</div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-determinatePageStartIdxByObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-determinatePageStartIdxByObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-determinatePageStartIdxByObjId' class='name expandable'>determinatePageStartIdxByObjId</a>( <span class='pre'>objId, pageSize</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>pageSize</span> : Number<div class='sub-desc'><p>Page size</p>\n</div></li></ul></div></div></div><div id='method-execute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-execute' class='name expandable'>execute</a>( <span class='pre'></span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Starts the collection of the desired data ...</div><div class='long'><p>Starts the collection of the desired data</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-findGuids' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-findGuids' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-findGuids' class='name expandable'>findGuids</a>( <span class='pre'>findInfo</span> ) : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findInfo</span> : de.elo.ix.client.FindInfo<div class='sub-desc'><p>Find info</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSordFormatter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-getSordFormatter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-getSordFormatter' class='name expandable'>getSordFormatter</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTypeConstants' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-getTypeConstants' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-getTypeConstants' class='name expandable'>getTypeConstants</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-method-initialize\" rel=\"sol.common.ix.ServiceBase-method-initialize\" class=\"docClass\">sol.common.ix.ServiceBase.initialize</a></p></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of services' process. ...</div><div class='long'><p>Implementation of services' process. This function must be implemented by the child class and should contain the logic of the function module.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_services_SordDataCollector_FindClose' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-static-method-RF_sol_common_services_SordDataCollector_FindClose' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-static-method-RF_sol_common_services_SordDataCollector_FindClose' class='name expandable'>RF_sol_common_services_SordDataCollector_FindClose</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_common_services_SordDataCollector_FindFirst' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-static-method-RF_sol_common_services_SordDataCollector_FindFirst' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-static-method-RF_sol_common_services_SordDataCollector_FindFirst' class='name expandable'>RF_sol_common_services_SordDataCollector_FindFirst</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_common_services_SordDataCollector_FindNext' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.SordDataCollector'>sol.common.ix.services.SordDataCollector</span><br/><a href='source/sol.common.ix.services.SordDataCollector.html#sol-common-ix-services-SordDataCollector-static-method-RF_sol_common_services_SordDataCollector_FindNext' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.SordDataCollector-static-method-RF_sol_common_services_SordDataCollector_FindNext' class='name expandable'>RF_sol_common_services_SordDataCollector_FindNext</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});